/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.nc2;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.nc2.NC2Datatype;
import ncsa.hdf.object.nc2.NC2File;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class NC2Dataset
extends ScalarDS {
    private static final long serialVersionUID = -6031051694304457461L;
    private List attributeList;
    private Variable nativeDataset;

    public NC2Dataset(FileFormat fileFormat, Variable ncDataset, long[] oid) {
        super(fileFormat, ncDataset.getName(), "/", oid);
        this.unsignedConverted = false;
        this.nativeDataset = ncDataset;
    }

    @Override
    public boolean hasAttribute() {
        return false;
    }

    @Override
    public Dataset copy(Group pgroup, String dstName, long[] dims, Object buff) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public byte[] readBytes() throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public Object read() throws Exception {
        String[] theData = null;
        if (this.nativeDataset == null) {
            return null;
        }
        int[] origin = new int[this.rank];
        int[] shape = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            origin[i] = (int)this.startDims[i];
            shape[i] = (int)this.selectedDims[i];
        }
        Array ncArray = null;
        try {
            ncArray = this.nativeDataset.read(origin, shape);
        }
        catch (Exception ex) {
            ncArray = this.nativeDataset.read();
        }
        String[] oneD = ncArray.copyTo1DJavaArray();
        if (oneD == null) {
            return null;
        }
        if (oneD.getClass().getName().startsWith("[C")) {
            char[] charA = (char[])oneD;
            int nCols = (int)this.selectedDims[this.selectedIndex[1]];
            int nRows = (int)this.selectedDims[this.selectedIndex[0]];
            String[] strA = new String[nRows];
            String allStr = new String(charA);
            int indx0 = 0;
            for (int i = 0; i < nRows; ++i) {
                indx0 = i * nCols;
                strA[i] = allStr.substring(indx0, indx0 + nCols);
            }
            theData = strA;
        } else {
            theData = oneD;
        }
        return theData;
    }

    @Override
    public void write(Object buf) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public List getMetadata() throws Exception {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        if (this.nativeDataset == null) {
            this.attributeList = null;
            return null;
        }
        List<Attribute> ncAttrList = this.nativeDataset.getAttributes();
        if (ncAttrList == null) {
            this.attributeList = null;
            return null;
        }
        int n = ncAttrList.size();
        this.attributeList = new Vector(n);
        Attribute ncAttr = null;
        for (int i = 0; i < n; ++i) {
            ncAttr = ncAttrList.get(i);
            this.attributeList.add(NC2File.convertAttribute(ncAttr));
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object info) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public void removeMetadata(Object info) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public int open() {
        return -1;
    }

    @Override
    public void close(int did) {
    }

    @Override
    public void init() {
        int i;
        if (this.nativeDataset == null) {
            return;
        }
        if (this.rank > 0) {
            return;
        }
        this.isText = this.nativeDataset.getDataType().equals((Object)DataType.STRING);
        boolean isChar = this.nativeDataset.getDataType().equals((Object)DataType.CHAR);
        this.rank = this.nativeDataset.getRank();
        if (this.rank == 0) {
            this.rank = 1;
            this.dims = new long[1];
            this.dims[0] = 1L;
        } else {
            this.dims = new long[this.rank];
            for (i = 0; i < this.rank; ++i) {
                this.dims[i] = this.nativeDataset.getDimension(i).getLength();
            }
        }
        this.startDims = new long[this.rank];
        this.selectedDims = new long[this.rank];
        for (i = 0; i < this.rank; ++i) {
            this.startDims[i] = 0L;
            this.selectedDims[i] = 1L;
        }
        if (this.rank == 1) {
            this.selectedIndex[0] = 0;
            this.selectedDims[0] = this.dims[0];
        } else if (this.rank == 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        } else if (this.rank > 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedIndex[2] = 2;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        }
        if (this.rank > 1 && this.isText) {
            this.selectedDims[1] = 1L;
        }
    }

    @Override
    public byte[][] getPalette() {
        if (this.palette == null) {
            this.palette = this.readPalette(0);
        }
        return this.palette;
    }

    @Override
    public byte[][] readPalette(int idx) {
        return null;
    }

    public static NC2Dataset create(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, Object data) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public byte[] getPaletteRefs() {
        return null;
    }

    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            this.datatype = new NC2Datatype(this.nativeDataset.getDataType());
        }
        return this.datatype;
    }

    @Override
    public void setName(String newName) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    public List getMetadata(int ... attrPropList) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

