/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.io.Serializable;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;

public abstract class HObject
implements Serializable,
DataFormat {
    private static final long serialVersionUID = -1723666708199882519L;
    public static final String separator = "/";
    private String filename;
    private final FileFormat fileFormat;
    private String name;
    private String path;
    private String fullName;
    protected long[] oid;
    protected String linkTargetObjName;

    public HObject() {
        this(null, null, null, null);
    }

    public HObject(FileFormat theFile, String theName, String thePath) {
        this(theFile, theName, thePath, null);
    }

    @Deprecated
    public HObject(FileFormat theFile, String theName, String thePath, long[] oid) {
        this.fileFormat = theFile;
        this.oid = oid;
        this.filename = this.fileFormat != null ? this.fileFormat.getFilePath() : null;
        if (theName == null && thePath != null) {
            if (thePath.equals(separator)) {
                theName = separator;
                thePath = null;
            } else {
                if (!thePath.startsWith(separator)) {
                    thePath = separator + thePath;
                }
                if (thePath.endsWith(separator)) {
                    thePath = thePath.substring(0, thePath.length() - 1);
                }
                theName = thePath.substring(thePath.lastIndexOf(separator) + 1);
                thePath = thePath.substring(0, thePath.lastIndexOf(separator));
            }
        } else if (theName != null && thePath == null && theName.indexOf(separator) >= 0) {
            if (theName.equals(separator)) {
                theName = separator;
                thePath = null;
            } else {
                int idx;
                if (!theName.startsWith(separator)) {
                    theName = separator + theName;
                }
                int n = theName.length();
                if (theName.endsWith(separator)) {
                    theName = theName.substring(0, n - 1);
                }
                if ((idx = theName.lastIndexOf(separator)) < 0) {
                    thePath = separator;
                } else {
                    thePath = theName.substring(0, idx);
                    theName = theName.substring(idx + 1);
                }
            }
        }
        if (thePath != null && !(thePath = thePath.replaceAll("//", separator)).endsWith(separator)) {
            thePath = thePath + separator;
        }
        this.name = theName;
        this.path = thePath;
        this.fullName = thePath != null ? thePath + theName : (theName == null ? separator : (theName.startsWith(separator) ? theName : separator + theName));
    }

    protected final void debug(Object msg) {
        System.out.println("*** " + this.getClass().getName() + ": " + msg);
    }

    @Override
    public final String getFile() {
        return this.filename;
    }

    public final String getName() {
        return this.name;
    }

    public final String getLinkTargetObjName() {
        return this.linkTargetObjName;
    }

    public final void setLinkTargetObjName(String targetObjName) {
        this.linkTargetObjName = targetObjName;
    }

    public final String getFullName() {
        return this.fullName;
    }

    public final String getPath() {
        return this.path;
    }

    public void setName(String newName) throws Exception {
        if (newName != null) {
            if (newName.equals(separator)) {
                throw new IllegalArgumentException("The new name cannot be the root");
            }
            if (newName.startsWith(separator)) {
                newName = newName.substring(1);
            }
            if (newName.endsWith(separator)) {
                newName = newName.substring(0, newName.length() - 2);
            }
            if (newName.contains(separator)) {
                throw new IllegalArgumentException("The new name contains the separator character: /");
            }
        }
        this.name = newName;
    }

    public void setPath(String newPath) throws Exception {
        if (newPath == null) {
            newPath = separator;
        }
        this.path = newPath;
    }

    public abstract int open();

    public abstract void close(int var1);

    public final int getFID() {
        if (this.fileFormat != null) {
            return this.fileFormat.getFID();
        }
        return -1;
    }

    public final boolean equalsOID(long[] theID) {
        if (theID == null || this.oid == null) {
            return false;
        }
        int n1 = theID.length;
        int n2 = this.oid.length;
        if (n1 == 0 || n2 == 0) {
            return false;
        }
        int n = Math.min(n1, n2);
        boolean isMatched = theID[0] == this.oid[0];
        for (int i = 1; isMatched && i < n; ++i) {
            isMatched = theID[i] == this.oid[i];
        }
        return isMatched;
    }

    public final FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public final long[] getOID() {
        if (this.oid == null) {
            return null;
        }
        return (long[])this.oid.clone();
    }

    public String toString() {
        if (this instanceof Group && ((Group)this).isRoot() && this.getFileFormat() != null) {
            return this.getFileFormat().getName();
        }
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }
}

