package com.hbaspecto.pecas.sd.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import simpleorm.dataset.SQuery;
import simpleorm.sessionjdbc.SSessionJdbc;

/**
 * Business rules class for table luzs.<br>
 * Will not be regenerated by SimpleORMGenerator, add any business rules to this
 * class
 **/

@SuppressWarnings("serial")
public class Luzs extends Luzs_gen implements java.io.Serializable {

    public static ArrayList<Integer> getZoneNumbers(SSessionJdbc session) {
        SQuery<Luzs> qry = new SQuery<>(Luzs.meta);
        List<Luzs> luzs = session.query(qry);
        return luzs.stream().map(r -> r.get_LuzNumber())
                .collect(Collectors.toCollection(() -> new ArrayList<>()));
    }
}
