package com.hbaspecto.pecas.sd.orm;

import java.util.List;

import org.apache.log4j.Logger;

import com.hbaspecto.pecas.sd.SessionLocalMap;

import simpleorm.dataset.SQuery;
import simpleorm.sessionjdbc.SSessionJdbc;

/**
 * Business rules class for table local_effect_parameters.<br>
 * Will not be regenerated by SimpleORMGenerator, add any business rules to this
 * class
 **/

@SuppressWarnings("serial")
public class LocalEffectParameters extends LocalEffectParameters_gen
        implements java.io.Serializable {

    static boolean queried = false;

    private static SessionLocalMap<Key, LocalEffectParameters> sessionMap = new SessionLocalMap<Key, LocalEffectParameters>() {

        @Override
        protected LocalEffectParameters findRecord(SSessionJdbc session,
                Key key) {
            return session.find(meta, key.localEffectId, key.spaceTypeId);
        }

        @Override
        protected List<LocalEffectParameters> findAllRecords(
                SSessionJdbc session) {
            SQuery<LocalEffectParameters> qry = new SQuery<>(
                    LocalEffectParameters.meta).ascending(LocalEffectId)
                            .ascending(SpaceTypeId);
            return session.query(qry);
        }

        @Override
        protected Key getKeyFromRecord(LocalEffectParameters record) {
            return new Key(record.get_LocalEffectId(), record.get_SpaceTypeId());
        }

    };

    public static LocalEffectParameters findInCache(int localEffectId,
            int spaceTypeID) {
        return sessionMap.getRecordIfExists(new Key(localEffectId, spaceTypeID)).orElse(null);
    }

    static final Logger logger = Logger.getLogger(LocalEffectParameters.class);

    public double applyFunction(double rent, double localEffectDistance) {
        localEffectDistance = Math.min(localEffectDistance, get_MaxDist());
        switch (get_FunctionType()) {
        case 1:
            if (localEffectDistance == get_MaxDist())
                rent *= get_ThetaParameter();
            break;
        case 2:
            rent *= Math.exp(get_ThetaParameter()
                    * (localEffectDistance / get_MaxDist()));
            break;
        case 3:
            rent *= Math.exp(get_ThetaParameter()
                    * (1 - (localEffectDistance / get_MaxDist())));
            break;
        case 4:
            rent *= Math.pow(get_ThetaParameter(),
                    localEffectDistance / get_MaxDist());
            break;
        case 5:
            rent *= Math.pow(get_ThetaParameter(),
                    1 - (localEffectDistance / get_MaxDist()));
            break;
        case 6:
            rent *= Math.pow(1 - get_ThetaParameter(),
                    (localEffectDistance / get_MaxDist()));
            break;
        case 7:
            rent *= Math.pow(1 - get_ThetaParameter(),
                    1 - (localEffectDistance / get_MaxDist()));
            break;
        case 8:
            rent *= Math.pow((localEffectDistance / get_MaxDist()),
                    get_ThetaParameter());
            break;
        case 9:
            rent *= Math.pow(1 - (localEffectDistance / get_MaxDist()),
                    get_ThetaParameter());
            break;
        default:
            logger.fatal("Invalid local effect function " + get_FunctionType()
                    + " Only 1-9 are defined");
            throw new RuntimeException("Invalid local effect function "
                    + get_FunctionType() + " Only 1-9 are defined");

        }
        return rent;
    }

    public double applyFunctionForMaxDist(double rent) {
        switch (get_FunctionType()) {
        case 1:
        case 4:
            rent *= get_ThetaParameter();
            break;
        case 2:
            rent *= Math.exp(get_ThetaParameter());
            break;
        case 3:
        case 5:
        case 7:
        case 8:
            rent *= 1;
            break;
        case 6:
            rent *= 1 - get_ThetaParameter();
            break;
        case 9:
            rent *= 0;
            break;
        default:
            logger.fatal("Invalid local effect function " + get_FunctionType()
                    + " Only 1-9 are defined");
            throw new RuntimeException("Invalid local effect function "
                    + get_FunctionType() + " Only 1-9 are defined");

        }
        return rent;
    }

    public static class Key {
        public final int localEffectId;
        public final int spaceTypeId;

        public Key(int localEffectId, int spaceTypeId) {
            this.localEffectId = localEffectId;
            this.spaceTypeId = spaceTypeId;
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + localEffectId;
            result = prime * result + spaceTypeId;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj)
                return true;
            if (!(obj instanceof Key))
                return false;
            Key other = (Key) obj;
            return (localEffectId == other.localEffectId)
                    && (spaceTypeId == other.spaceTypeId);
        }

        @Override
        public String toString() {
            return "Key(lef=" + localEffectId + ", space=" + spaceTypeId + ")";
        }
    }
}
