/*
 * Created on 28-Oct-2005
 *
 * Copyright  2006 HBA Specto Incorporated
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package com.hbaspecto.pecas.sd;

import org.apache.log4j.Logger;

import com.hbaspecto.pecas.sd.orm.ZoningPermissions_gen;

public class ZoningPermissions extends ZoningPermissions_gen{
    protected static transient Logger logger = Logger.getLogger(ZoningPermissions.class);
    static double maxMinPercentageOfMax = 0.9;
   
    public double get_MaxIntensityPermitted() {
        if (super.get_MaxIntensityPermitted()<0) throw new Error("Tried to specify a negative Maximum FAR");      
       return super.get_MaxIntensityPermitted();
    }

    public double get_MinIntensityPermitted() {
        if (super.get_MinIntensityPermitted() > super.get_MaxIntensityPermitted()*maxMinPercentageOfMax) throw new RuntimeException("Tried to specifiy a minimum FAR greater than "+maxMinPercentageOfMax+" times the maximum FAR");
        return super.get_MinIntensityPermitted();
    }
}