package com.hbaspecto.pecas.land;

import java.util.ArrayList;
import java.util.List;

import com.hbaspecto.pecas.sd.orm.TazGroupConstants;
import com.hbaspecto.pecas.sd.orm.TazGroups;
import com.hbaspecto.pecas.sd.orm.TazsByTazGroup;
import com.hbaspecto.pecas.sd.orm.Tazs_gen;

import simpleorm.dataset.SQuery;
import simpleorm.sessionjdbc.SSessionJdbc;

/**
 * Business rules class for table tazs.<br>
 * Will not be regenerated by SimpleORMGenerator, add any business rules to this
 * class
 **/

@SuppressWarnings("serial")
public class Tazs extends Tazs_gen implements java.io.Serializable {
    
    private boolean tazGroupFound = false;
    private TazGroups tazGroup;
    
    private static ThreadLocal<Boolean> isCachedAlready = new ThreadLocal<Boolean>() {
        @Override
        public Boolean initialValue() {
            return false;
        }
    };

    public static ArrayList<Integer> getZoneNumbers(SSessionJdbc session) {
        // SSessionJdbc session = SSessionJdbc.getThreadLocalSession();
        List<Tazs> tazs = getAllTazRecords(session);

        ArrayList<Integer> zoneNumbersInt = new ArrayList<Integer>();

        for (Tazs taz : tazs) {
            zoneNumbersInt.add(taz.get_TazNumber());
        }
        return zoneNumbersInt;
    }

    /**
     * @param session
     * @return
     */
    private synchronized static List<Tazs> getAllTazRecords(SSessionJdbc session) {

        SQuery<Tazs> qry = new SQuery<>(Tazs.meta);
        boolean wasBegun = true;
        if (!session.hasBegun()) {
            session.begin();
            wasBegun = false;
        }
        List<Tazs> tazs = session.query(qry);
        isCachedAlready.set(true);
        if (!wasBegun)
            session.commit();
        return tazs;
    }

    private static Tazs getTazRecord(SSessionJdbc session, int tazNumber) {

        if (!isCachedAlready.get())
            getAllTazRecords(session);

        Tazs oneTaz = session.getDataSet().find(meta, tazNumber);
        return oneTaz;
    }

    public static Tazs getTazRecord(int tazNumber) {
        return getTazRecord(SSessionJdbc.getThreadLocalSession(), tazNumber);
    }

    /**
     * Returns the TAZ group that this TAZ belongs to, or null if it is not
     * assigned to a group.
     * 
     * @return The TAZ group
     */
    public TazGroups getTazGroup() {
        if (!tazGroupFound) {
            SSessionJdbc session = SSessionJdbc.getThreadLocalSession();
            boolean wasBegun = true;
            if (!session.hasBegun()) {
                session.begin();
                wasBegun = false;
            }
            SQuery<TazsByTazGroup> qry = new SQuery<TazsByTazGroup>(
                    TazsByTazGroup.meta).eq(TazsByTazGroup.TazNumber, get_TazNumber());
            TazsByTazGroup result = session.query(qry).oneOrNone();
            if (result == null)
                tazGroup = null;
            else {
                tazGroup = session.mustFind(TazGroups.meta, result.get_TazGroupId());
            }
            if (!wasBegun)
                session.commit();
            tazGroupFound = true;
        }
        
        return tazGroup;
    }

    public double getConstructionConstant() {
        TazGroups group = getTazGroup();
        if (group == null) {
            return 0;
        } else {
            return group.getConstructionConstant();
        }
    }
}
