package com.hbaspecto.pecas.land;

import java.util.List;

import org.apache.log4j.Logger;

import simpleorm.dataset.SQuery;
import simpleorm.sessionjdbc.SSessionJdbc;

import com.hbaspecto.pecas.sd.orm.ParcelsTemp_gen;

/**Business rules class for table parcels_view.<br>
 * Will not be regenerated by SimpleORMGenerator, add any business rules to this class
 **/

public class ParcelsTemp extends ParcelsTemp_gen implements java.io.Serializable, ParcelInterface {

    static Logger logger = Logger.getLogger(ParcelsTemp.class);

    public static List<ParcelsTemp> getParcelsForTaz(SSessionJdbc session, int tazNumber){

        logger.info("Getting parcels ... "+tazNumber);

        SQuery<ParcelsTemp> query = new SQuery<ParcelsTemp>(ParcelsTemp.meta).eq(Taz, tazNumber);

        List<ParcelsTemp> parcelsInCurrentTAZ = session.query(query);

        return parcelsInCurrentTAZ;
    }

    public static List<ParcelsTemp> getParcelsWithRandomNumber(SSessionJdbc session, int RandomNumber){

        logger.info("Getting parcels with random number: "+RandomNumber);

        SQuery<ParcelsTemp> query = new SQuery<ParcelsTemp>(ParcelsTemp.meta).eq(Randnum, RandomNumber);

        List<ParcelsTemp> parcelsWithCurrentNumber = session.query(query);

        return parcelsWithCurrentNumber;
    }

    public static List<ParcelsTemp> getAllParcels(SSessionJdbc session){

        logger.info("Getting all parcels ...");

        SQuery<ParcelsTemp> query = new SQuery<ParcelsTemp>(ParcelsTemp.meta);

        List<ParcelsTemp> allParcels = session.query(query);

        return allParcels;
    }

    public static int getRandomNumberForParcel(SSessionJdbc session, long pecasParcelNum) {
        return (int) session.mustFind(ParcelsTemp.meta, pecasParcelNum).get_Randnum();
    }

}

