/*
 * Copyright  2005 HBA Specto Incorporated
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
/* Generated by Together */

package com.hbaspecto.pecas.aa.travelAttributes;



public class TimeAndDistanceTravelUtilityCalculator implements TravelUtilityCalculatorInterface {

    public double valueOfTime;
    public double scale = 1.0;
    public double costOfDistance;

    public TimeAndDistanceTravelUtilityCalculator(double valueOfTime, double costOfDistance) {
        this.valueOfTime = valueOfTime;
        this.costOfDistance = costOfDistance;
    }

    public TimeAndDistanceTravelUtilityCalculator(double valueOfTime, double costOfDistance, double scale) {
        this.costOfDistance = costOfDistance;
        this.valueOfTime = valueOfTime;
        this.scale = scale;
    }

    public double getValueOfTime() {
        return valueOfTime;
    }

    public void setValueOfTime(double valueOfTime) {
        this.valueOfTime = valueOfTime;
    }

    public double getUtility(int origin, int destination, TravelAttributesInterface travelAttributes) {
        if (travelAttributes instanceof DistanceAndTime) {
            DistanceAndTime dAndT = (DistanceAndTime) travelAttributes;
            // debug February 26 2002 -- workaround NaN skim distances by setting costOfDistance=0
            double compositeUtility;
            if (costOfDistance == 0)
                compositeUtility = valueOfTime * dAndT.time;
            else
                compositeUtility = dAndT.distance * costOfDistance + valueOfTime * dAndT.time;
            return compositeUtility * scale;
        }
        throw new Error("TimeAndDistanceTravelUtilityCalculator doesn't know how to deal with TravelAttributes of type " + travelAttributes.getClass().getName());
    }

     public String toString() {
        return "Utility Calculator: VOT=" + valueOfTime + " COD=" + costOfDistance + " scale=" + scale;
    }

    /* (non-Javadoc)
     * @see com.pb.models.pecas.TravelUtilityCalculatorInterface#getUtilityComponents(int, int, com.pb.models.pecas.TravelAttributesInterface)
     */
    public double[] getUtilityComponents(int fromZoneUserNumber, int toZoneUserNumber, TravelAttributesInterface travelAttributes) {
        if (travelAttributes instanceof DistanceAndTime) {
            DistanceAndTime dAndT = (DistanceAndTime) travelAttributes;
            // debug February 26 2002 -- workaround NaN skim distances by setting costOfDistance=0
            double[] components = new double[2];
            components[1] = valueOfTime * dAndT.time;
            components[0] = costOfDistance* dAndT.distance;
            return components;
        }
        throw new Error("TimeAndDistanceTravelUtilityCalculator doesn't know how to deal with TravelAttributes of type " + travelAttributes.getClass().getName());
    };


}

