/*
 *  Copyright 2005 HBA Specto Incorporated
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
/* Generated by Together */

package com.hbaspecto.pecas.aa.commodity;

import com.hbaspecto.pecas.InvalidFlowError;
import com.hbaspecto.pecas.zones.PECASZone;

public class NonTransportableExchange extends Exchange {

    final int myLocationIndex;

    public NonTransportableExchange(Commodity com, PECASZone zone) {
        super(com, zone, 1);
        myLocationIndex = zone.getZoneIndex();
    }

    void setFlowQuantity(int tazIndex, char selling, double quantity) {
        if (tazIndex != myLocationIndex) throw new Error("Non transportable exchange zone for " + myCommodity + " in zone " + exchangeLocationUserID + " had an inter-zonal flow assinged: only intrazonal flows allowed");
        if (selling == 's') {
            if (sellingToExchangeFlows[0] == null)
                throw new Error("trying to set quantity for nonexistent flow " + this + " " + selling + " " + tazIndex);
            sellingQuantities[0] = quantity;
        } else {
            if (buyingFromExchangeFlows[0] == null)
                throw new Error("trying to set quantity for nonexistent flow " + this + " " + selling + " " + tazIndex);
            buyingQuantities[0] = quantity;
        }
    }

    public double getFlowQuantity(int tazIndex, char selling) {
        if (tazIndex != myLocationIndex) throw new InvalidFlowError("Non transportable exchange zone for " + myCommodity + " in zone " + exchangeLocationUserID + " had an inter-zonal flow assinged: only intrazonal flows allowed");
        if (selling == 's') {
            if (sellingToExchangeFlows[0] == null)
                throw new InvalidFlowError("trying to get quantity for nonexistent flow " + this + " " + selling + " " + tazIndex);
            return sellingQuantities[0];
        } else {
            if (buyingFromExchangeFlows[0] == null)
                throw new InvalidFlowError("trying to get quantity for nonexistent flow " + this + " " + selling + " " + tazIndex);
            return buyingQuantities[0];
        }
    }

    @Override
    double getFlowQuantityZeroForNonExistantFlow(int tazIndex, char selling) {
        if (tazIndex != myLocationIndex) return 0;
        if (selling == 's') {
            if (sellingToExchangeFlows[0] == null)
                return 0;
            return sellingQuantities[0];
        } else {
            if (buyingFromExchangeFlows[0] == null)
                return 0;
            return buyingQuantities[0];
        }
    }

    public void addFlowIfNotAlreadyThere(CommodityZUtility f, boolean buying) {
        int tazIndex = f.myLuz.getZoneIndex();
        if (tazIndex != myLocationIndex) throw new Error("Attempt to add an Interzonal flow to a non-transportable exchange " + myCommodity + " in zone " + exchangeLocationUserID);
        if (buying) {
            buyingFromExchangeFlows[0] = f;
            buyingQuantities[0] = 0;
        } else {
            sellingToExchangeFlows[0] = f;
            sellingQuantities[0] = 0;
        }
    }


}
