/*
 *  Copyright 2005 HBA Specto Incorpoated
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
/* Generated by Together */

package com.hbaspecto.pecas.aa.commodity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Logger;

import com.hbaspecto.pecas.OverflowException;
import com.hbaspecto.pecas.aa.travelAttributes.TravelUtilityCalculatorInterface;
import com.hbaspecto.pecas.zones.AbstractZone;

abstract public class AbstractCommodity {

    private static Logger logger = Logger.getLogger(AbstractCommodity.class);
    private static int nextCommodityNumber = 0;
    public final int commodityIndex;
    public final int commodityNumber;
    protected static final Map<String, AbstractCommodity> allCommoditiesHashmap = new HashMap<>();
    private static final List<AbstractCommodity> allCommoditiesArrayList = new ArrayList<AbstractCommodity>();
    private static final Set<Integer> takenNumbers = new HashSet<>();
    /** An attribute that represents ... */
    public final String name;
    /**
     * Commodities have certain "preferences" regarding what time they are
     * shipped, what modes they are shipped on, and how time sensitive they are.
     * These are the travel preferences for shipping the commodity from the
     * exchange zone
     */
    protected TravelUtilityCalculatorInterface commodityTravelPreferences;

    /**
     * Create an AbstractCommodity with the default (sequential) commodity
     * number.
     * 
     * @param name The name of the commodity
     */
    protected AbstractCommodity(String name) {
        this(name, nextCommodityNumber);
    }

    protected AbstractCommodity(String name, int number) {
        if (allCommoditiesHashmap.containsKey(name)) {
            String msg = "Tried to create a duplicate commodity: " + name;
            logger.fatal(msg);
            throw new RuntimeException(msg);
        }
        if (takenNumbers.contains(number)) {
            String msg = "Tried to create two commodities with the same number: "
                    + number;
            logger.fatal(msg);
            throw new RuntimeException(msg);
        }
        this.name = name;
        commodityNumber = number;
        commodityIndex = nextCommodityNumber;
        nextCommodityNumber++;
        allCommoditiesHashmap.put(name, this);
        takenNumbers.add(number);
        allCommoditiesArrayList.add(this);
    }

    public void setCommodityTravelPreferences(
            TravelUtilityCalculatorInterface commodityTravelPreferences) {
        this.commodityTravelPreferences = commodityTravelPreferences;
    }

    public TravelUtilityCalculatorInterface getCommodityTravelPreferences() {
        return commodityTravelPreferences;
    }

    public String getName() {
        return name;
    }

    public String toString() {
        return name;
    };

    public int hashCode() {
        return name.hashCode();
    };

    /**
     * This gets the ZUtility for a commodity in a zone, either the selling
     * ZUtility or the buying ZUtility.
     * 
     * @param t the PECASZone to get the buying or selling utility of
     * @param selling if true, get the selling utility. Otherwise get the buying
     *            utility
     */
    public abstract double calcZUtility(AbstractZone t, boolean selling)
            throws OverflowException;

    /**
     * 
     * @return An unmodifiable collection of all the commodities that have been
     *         created
     */
    public static List<AbstractCommodity> getAllCommodities() {
        return allCommoditiesArrayList;
    }

}
