/*
 *  Copyright 2005 HBA Specto Incorporated
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
/* Generated by Together */

package com.hbaspecto.pecas.aa.activities;
import java.io.IOException;
import java.io.Writer;

import org.apache.log4j.Logger;

import com.hbaspecto.pecas.ChoiceModelOverflowException;
import com.hbaspecto.pecas.aa.control.AAControl;
import com.hbaspecto.pecas.zones.PECASZone;


public class AmountInZone {
    protected static Logger logger = Logger.getLogger(AmountInZone.class);

    public PECASZone myZone;
    protected ProductionActivity myProductionActivity;
    
    public double constraintQuantity =0;
    boolean constrained = false;

    private double activityZoneConstant;
    private double activityZoneConstantForSizeTerms;
    public double quantity = 0;
    private double allocationSizeTerm;

    public AmountInZone(ProductionActivity p, PECASZone z) {
      myProductionActivity = p;
      myZone = z;
    }

	public double getLocationSpecificUtilityInclTaxes() {
		if (AggregateActivity.isDoingAllocationForSizes()) 
		{
			if (myProductionActivity.constInExchangeSize) {
				return activityZoneConstantForSizeTerms;
			} else {
				return 0;
			}
		}

			return activityZoneConstant;
	}

    public void setLocationSpecificUtilityInclTaxes(double locationSpecificUtilityInclTaxes) {
    	if (AggregateActivity.isDoingAllocationForSizes() && myProductionActivity.constInExchangeSize) {
    		this.activityZoneConstantForSizeTerms = locationSpecificUtilityInclTaxes;
    	} else {
    		this.activityZoneConstant = locationSpecificUtilityInclTaxes;
    	}
    }

    public double getQuantity(){ return quantity; }

    public void setQuantity(double newQuantity) {
        quantity = newQuantity;
    }

    public PECASZone getMyZone() {
        return myZone;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AmountInZone)) {
            return false;
        }
        AmountInZone other = (AmountInZone) o;
        if (other.myZone.equals(myZone)
                && other.myProductionActivity.equals(myProductionActivity)) {
            return true;
        }
        return false;
    }

    public int hashCode() {return myProductionActivity.hashCode() ^ myZone.hashCode();};

    public double getAllocationSizeTerm(){ return allocationSizeTerm; }

    public void setAllocationSizeTerm(double allocationSizeTerm){ this.allocationSizeTerm = allocationSizeTerm; }


    
    /**
     * Method updateLocationUtilityTerms.
     * @param w
     * @throws ChoiceModelOverflowException 
     */
    public void writeLocationUtilityTerms(Writer w) throws ChoiceModelOverflowException {
    	// default behaviour is to terminate the line
        try {
            w.write("\n");
        } catch (IOException e) {
            System.out.println("error in location utility terms");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

	public void setConstrained(boolean constrained) {
		this.constrained = constrained;
		// constant is ignored in allocation but used in update, so let's set it to 0.
		this.setLocationSpecificUtilityInclTaxes(0);
	}

	public boolean isConstrained() {
		return constrained;
	}

	public double getActivityZoneConstantForSizeTerms() {
		// TODO Auto-generated method stub
		return activityZoneConstantForSizeTerms;
	}

	public void setActivityZoneConstantForSizeTerms(
			double activityZoneConstantForSizeTerms) {
		this.activityZoneConstantForSizeTerms = activityZoneConstantForSizeTerms;
	}

	public double getActivityZoneConstant() {
		return activityZoneConstant;
	}

	private void setActivityZoneConstant(double activityZoneConstant) {
		this.activityZoneConstant = activityZoneConstant;
	}

}
