/*
 *  Copyright 2005 HBA Specto Incorporated
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
/* Generated by Together */

package com.hbaspecto.functions;


//import com.pb.common.util.*;

public class ExponentialPlusBaseFunction extends NumericalDerivativeSingleParameterFunction {
    double base;
    double alpha;
    double lambda;
    double basePrice;

    public ExponentialPlusBaseFunction(double base, double alpha, double lambda, double basePrice) {
        super(0.01);
        this.base = base;
        this.alpha = alpha;
        this.lambda = lambda;
        this.basePrice = basePrice;
    }

    public double evaluate(double price) {
        return base + alpha * Math.exp(lambda * ((price - basePrice) / basePrice));
    }
}

;


