/*
 * Copyright  2005 PB Consult Inc.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package com.pb.common.assign;

import java.util.Arrays;
import org.apache.log4j.Logger;


public class Skims {

	protected static Logger logger = Logger.getLogger("com.pb.common.assign");

    Network g;



    public Skims (Network g) {

        this.g = g;

    }



	/** switch double[][] to float[][]
	 *
	 */
	public float[][] switchSkimToFloat(double[][] tempDoubleArray) {

		float[][] tempFloatArray = new float[tempDoubleArray.length][];
	    
	    for (int i=0; i < tempDoubleArray.length; i++) {
            tempFloatArray[i] = new float[tempDoubleArray[i].length];
            for (int j=0; j < tempDoubleArray[i].length; j++)
                tempFloatArray[i][j] = (float)tempDoubleArray[i][j];
	    }
	    
	    return tempFloatArray;
	}


	/** return sov time skims as float[][]
	 *
	 */
	public double[][] sovTimeSkim () {

		// set the highway network attribute on which to skim the network
		double[] linkCost = g.getCongestedTime();
		
		// determine which links are valid parts of paths for this skim
		boolean[] validLinks = new boolean[g.getLinkCount()];
		Arrays.fill (validLinks, false);
		String[] mode = g.getMode();
		for (int i=0; i < validLinks.length; i++) {
			if ( mode[i].indexOf('a') >= 0 )
				validLinks[i] = true;
		}
		
		return hwySkim ( linkCost, validLinks );
        
	}


	/** return sov distance skims as double[][]
	 *
	 */
	public double[][] sovDistSkim () {

		// set the highway network attribute on which to skim the network
		double[] linkCost = g.getDist();
		
		// determine which links are valid parts of paths for this skim
		boolean[] validLinks = new boolean[g.getLinkCount()];
		Arrays.fill (validLinks, false);
		String[] mode = g.getMode();
		for (int i=0; i < validLinks.length; i++) {
			if ( mode[i].indexOf('a') >= 0 )
				validLinks[i] = true;
		}
		
		return hwySkim ( linkCost, validLinks );
        
	}


	/** highway network skimming procedure
	 *
	 */
	private double[][] hwySkim ( double[] linkCost, boolean[] validLinks ) {

	    int i;
		double[][] skimMatrix = new double[g.getNumCentroids()][];

		// create a ShortestPathTreeH object
		ShortestPathTreeH sp = new ShortestPathTreeH( g );


		// build shortest path trees and get distance skims for each origin zone.
		sp.setLinkCost( linkCost );
		sp.setValidLinks( validLinks );
		
		
		for (i=0; i < g.getNumCentroids(); i++) {
		    if (i % 500 == 0)
		        logger.info ("shortest path tree for origin " + i);
			sp.buildTree( i );
			skimMatrix[i] = sp.getSkim();
		}
		if ( i > 1 )
		    logger.info ("shortest path tree for origin " + (i-1) );

		
//		sp.printPath( 3096, 2062 );
//		System.exit(1);
		
		

		return skimMatrix;
        
	}


}
