/*
 * Copyright  2005 PB Consult Inc.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package com.pb.common.assign;

import java.io.Serializable;
import java.text.DecimalFormat;

public class Justify implements Serializable {

    public DecimalFormat df0 = new DecimalFormat("###########");
    public DecimalFormat df1 = new DecimalFormat("###########.0");
    public DecimalFormat df2 = new DecimalFormat("###########.00");
    public DecimalFormat df3 = new DecimalFormat("###########.000");
    public DecimalFormat df4 = new DecimalFormat("###########.0000");
    public DecimalFormat df5 = new DecimalFormat("###########.00000");
    public DecimalFormat df6 = new DecimalFormat("###########.000000");
    public DecimalFormat df7 = new DecimalFormat("###########.0000000");
    public DecimalFormat df8 = new DecimalFormat("###########.00000000");
    public DecimalFormat df9 = new DecimalFormat("###########.000000000");

    public DecimalFormat[] df = new DecimalFormat[10];

    public Justify() {
        df[0] = df0;
        df[1] = df1;
        df[2] = df2;
        df[3] = df3;
        df[4] = df4;
        df[5] = df5;
        df[6] = df6;
        df[7] = df7;
        df[8] = df8;
        df[9] = df9;
    }


    public String right (String s, int width) {
        int len = width - s.length();
        if (len > 0) {
            char[] tempString = new char[len];
            for (int i=0; i < len; i++)
                tempString[i] = ' ';
            return(String.valueOf(tempString).concat(s));
        } else {
            return s.substring(0, width);
        }
    }

    public String right (boolean booleanValue, int width) {
        String s;

        if (booleanValue)
            s = "true";
        else
            s = "false";

        int len = width - s.length();
        if (len > 0) {
            char[] tempString = new char[len];
            for (int i=0; i < len; i++)
                tempString[i] = ' ';
            return(String.valueOf(tempString).concat(s));
        } else {
            return s.substring(0, width);
        }
    }

    public String right (int intValue, int width) {
        String s = Integer.toString(intValue);
        int len = width - s.length();
        if (len > 0) {
            char[] tempString = new char[len];
            for (int i=0; i < len; i++)
                tempString[i] = ' ';
            return(String.valueOf(tempString).concat(s));
        } else {
            return s.substring(0, width);
        }
    }

    public String right (float floatValue, int width, int decimals) {
        int intValue = (int)(floatValue*Math.pow(10,decimals) + 0.5);
        floatValue = (float)(intValue/Math.pow(10,decimals));
        String s = df[decimals].format(floatValue);
        int len = width - s.length();
        if (len > 0) {
            char[] tempString = new char[len];
            for (int i=0; i < len; i++)
                tempString[i] = ' ';
            return(String.valueOf(tempString).concat(s));
        } else {
            return s.substring(0, width);
        }
    }

    public String right (double doubleValue, int width, int decimals) {

        String s1 = df[decimals+1].format(doubleValue);
        String s2 = df[decimals].format(doubleValue);


        double intValue = (double)(doubleValue*Math.pow(10,decimals) + 0.5);
        doubleValue = (double)(intValue/Math.pow(10,decimals));
        String s = df[decimals].format(doubleValue);
        int len = width - s.length();
        if (len > 0) {
            char[] tempString = new char[len];
            for (int i=0; i < len; i++)
                tempString[i] = ' ';
            return(String.valueOf(tempString).concat(s));
        } else {
            return s.substring(0, width);
        }
    }

    public String left (String s, int width) {
        int len = width - s.length();
        if (len > 0) {
            char[] tempString = new char[len];
            for (int i=0; i < len; i++)
                tempString[i] = ' ';
            return(s.concat(String.valueOf(tempString)));
        } else {
            return s.substring(0, width);
        }
    }

    public String left (boolean booleanValue, int width) {
        String s;

        if (booleanValue)
            s = "true";
        else
            s = "false";

        int len = width - s.length();
        if (len > 0) {
            char[] tempString = new char[len];
            for (int i=0; i < len; i++)
                tempString[i] = ' ';
            return(s.concat(String.valueOf(tempString)));
        } else {
            return s.substring(0, width);
        }
    }

    public String left (int intValue, int width) {
        String s = Integer.toString(intValue);
        int len = width - s.length();
        if (len > 0) {
            char[] tempString = new char[len];
            for (int i=0; i < len; i++)
                tempString[i] = ' ';
            return(s.concat(String.valueOf(tempString)));
        } else {
            return s.substring(0, width);
        }
    }

    public String left (float floatValue, int width, int decimals) {
        double intValue = (double)(floatValue*Math.pow(10,decimals) + 0.5);
        floatValue = (float)(intValue/Math.pow(10,decimals));
        String s = df[decimals].format(floatValue);
        int len = width - s.length();
        if (len > 0) {
            char[] tempString = new char[len];
            for (int i=0; i < len; i++)
                tempString[i] = ' ';
            return(s.concat(String.valueOf(tempString)));
        } else {
            return s.substring(0, width);
        }
    }

    public String left (double doubleValue, int width, int decimals) {
        double intValue = (double)(doubleValue*Math.pow(10,decimals) + 0.5);
        doubleValue = (double)(intValue/Math.pow(10,decimals));
        String s = df[decimals].format(doubleValue);
        int len = width - s.length();
        if (len > 0) {
            char[] tempString = new char[len];
            for (int i=0; i < len; i++)
                tempString[i] = ' ';
            return(s.concat(String.valueOf(tempString)));
        } else {
            return s.substring(0, width);
        }
    }
}

