package com.hbaspecto.pecas.assign;

import java.io.File;

import com.pb.common.matrix.AlphaToBeta;
import com.pb.common.matrix.CSVMatrixWriter;
import com.pb.common.matrix.Matrix;
import com.pb.common.matrix.MatrixCompression;
import com.pb.common.matrix.MatrixReader;
import com.pb.common.matrix.MatrixType;
import com.pb.common.matrix.MatrixWriter;

public class SqueezeMatrices {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		String format = args[0];
		File inputFile = new File(args[1]);
		File outputFile = new File(args[2]);

		MatrixType type = MatrixReader.determineMatrixType(inputFile);
		MatrixReader reader = MatrixReader.createReader(type, inputFile);
		Matrix[] matrices = reader.readMatrices();
		AlphaToBeta a2b = new AlphaToBeta(new File(args[1]), "TAZ", "LUZ");
		MatrixCompression compressor = new MatrixCompression(a2b);
		Matrix[] squeezedMatrices = new Matrix[matrices.length];

		int mNum =0;
		for (Matrix m : matrices) {
			squeezedMatrices[mNum] = compressor.getCompressedMatrix(m, "MEAN");
			mNum++;
		}
		MatrixWriter skimWriter = MatrixWriter.createWriter(type, outputFile);
		String[] names = new String[matrices.length];
		int mnum = 0;
		for (Matrix m2: matrices) {
			names[mnum] = m2.getName();
			if (names[mnum]==null) names[mnum] = "Matrix "+mnum;
			else if (names[mnum].equals("")) names[mnum] = "Matrix "+mnum;
			mnum++;
		}
		skimWriter.writeMatrices(names, squeezedMatrices);
	}
}
	

