/*
 * Copyright  2005 PB Consult Inc.
 *  2009 HBA Specto Incorporated
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package com.hbaspecto.pecas.assign;
import  com.pb.common.assign.*;

/**
 *
 * @author    Jim Hicks
 * @version   1.0, 5/7/2004
 */


import com.pb.common.assign.Network;
import com.pb.common.assign.Skims;
import com.pb.common.assign.FW;
import com.pb.common.assign.TripDataGenerator;
import com.pb.common.datafile.CSVFileReader;
import com.pb.common.datafile.CSVFileWriter;
import com.pb.common.datafile.TableDataSet;
import com.pb.common.datafile.TableDataSet.TableDataSetWatcher;

import com.pb.common.matrix.AlphaToBeta;
import com.pb.common.matrix.CSVMatrixWriter;
import com.pb.common.matrix.Emme2311MatrixReader;
import com.pb.common.matrix.Emme2311MatrixWriter;
import com.pb.common.matrix.Matrix;
import com.pb.common.matrix.MatrixCompression;
import com.pb.common.matrix.MatrixUtil;
import com.pb.common.matrix.MatrixWriter;
import com.pb.common.util.ResourceUtil;

import java.util.HashMap;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import org.apache.log4j.Logger;



public class PecasAssign {

	protected static Logger logger = Logger.getLogger("com.pb.common.assign.tests");

	HashMap propertyMap;

	double[][][] multiclassTripTable = new double[2][][];
	
	Network g = null;
	
	
	
	public PecasAssign() {

	    propertyMap = ResourceUtil.getResourceBundleAsHashMap("assign");

	}
    
	
	
    public static void main (String[] args) {
        
		PecasAssign assigner = new PecasAssign();

		assigner.doPecasAssignment();
		
    }

    
    
    private void doPecasAssignment () {
        
		long totalTime = 0;
		long startTime = System.currentTimeMillis();
		

		int totalTrips;
		int linkCount;
		String myDateString;

		myDateString = DateFormat.getDateTimeInstance().format(new Date());
		logger.info ("creating Network object at: " + myDateString);
		g = new Network( propertyMap );
		
		
		// create Frank-Wolfe Algortihm Object
		myDateString = DateFormat.getDateTimeInstance().format(new Date());
		logger.info ("creating FW object at: " + myDateString);
		FW fw = new FW( propertyMap, g );


		// create highway skims object
		/*myDateString = DateFormat.getDateTimeInstance().format(new Date());
		logger.info ("creating hwy skims object at: " + myDateString);
		Skims highwaySkims = new Skims(g);

		myDateString = DateFormat.getDateTimeInstance().format(new Date());
		logger.info ("generating trips with gravity model at: " + myDateString);
		TripDataGenerator tdm = new TripDataGenerator ( highwaySkims.sovDistSkim() );*/

		String emme2ODMatrixFileName = (String) propertyMap.get("d311.fileName");
		
		Emme2311MatrixReader odReader = new Emme2311MatrixReader(new File(emme2ODMatrixFileName));
		Matrix m = odReader.readMatrix();

		//Compute Frank-Wolfe solution
		myDateString = DateFormat.getDateTimeInstance().format(new Date());
		logger.info ("starting fw at: " + myDateString);
		multiclassTripTable[0] = MatrixUtil.getInternalDoubleMatrix(m); 
		fw.iterate ( multiclassTripTable );

        
		myDateString = DateFormat.getDateTimeInstance().format(new Date());
		logger.info ("done at: " + myDateString);
		totalTime = (System.currentTimeMillis() - startTime);
		logger.info ("done with Frank-Wolfe assignment: " + myDateString);
		logger.info ("total time: " + totalTime);
		
		Skims highwaySkims = new Skims(g);
		
		Matrix[] mySkims = new Matrix[2];
		String[] names = new String[2];
		
		int[] externalNumbers = m.getExternalNumbers();
		names[0] = "distance";
		mySkims[0] = new Matrix(highwaySkims.switchSkimToFloat(highwaySkims.sovDistSkim()));
		mySkims[0].setName("distance");
		mySkims[0].setExternalNumbers(externalNumbers);
		
		names[1] = "time";
		mySkims[1] = new Matrix(highwaySkims.switchSkimToFloat(highwaySkims.sovTimeSkim()));
		mySkims[1].setName("time");
		mySkims[1].setExternalNumbers(externalNumbers);
		
		MatrixWriter skimWriter = new CSVMatrixWriter(new File((String) propertyMap.get("skim.fileName")));
		skimWriter.writeMatrices(names, mySkims);
		
		writeLUZMatrices(names, mySkims);
		
		
		TableDataSet links = g.getLinkTable();
		
		CSVFileWriter writer = new CSVFileWriter();
		try {
			writer.writeFile(links, new File("LoadedLinks.csv"));
		} catch (IOException e) {
			e.printStackTrace();
		}


		logger.info("HwyDistSkimsTest() finished in " +
			((System.currentTimeMillis() - startTime) / 60000.0) + " minutes");

    }



	private void writeLUZMatrices(String[] names, Matrix[] mySkims) {
		
		AlphaToBeta a2b = new AlphaToBeta(new File(propertyMap.get("tr.reference.data")+"FloorspaceZonesI.csv"), "TAZ", "LUZ");
		MatrixCompression compressor = new MatrixCompression(a2b);
		Matrix[] squeezedMatrices = new Matrix[mySkims.length];
		
		int mNum =0;
		for (Matrix m : mySkims) {
			squeezedMatrices[mNum] = compressor.getCompressedMatrix(m, "MEAN");
			mNum++;
		}
		MatrixWriter skimWriter = new CSVMatrixWriter(new File((String) propertyMap.get("luzSkim.fileName")));
		skimWriter.writeMatrices(names, squeezedMatrices);
	}
    
}
